﻿Imports System.Drawing.Printing

Public Class Dialogs
    'Declare variables and objects
    Private strFileName As String
    Private strPrintRecord As String

    Private WithEvents DialogsPrintDocument As PrintDocument

    Private Sub btnOpen_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles btnOpen.Click
        'Ustawianie właściwości okna dialogowego Otwórz.
        With OpenFileDialog1
            .Filter = "Pliki tekstowe (*.txt)|*.txt|Wszystkie pliki (*.*)|*.*"
            .FilterIndex = 1
            .Title = "Okno dialogowe Otwórz"
        End With

        'Wyświetlanie okna dialogowego Otwórz. 
        'Jeśli użytkownik kliknie przycisk
        'Otwórz w tym oknie, program załaduje plik.
        If OpenFileDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            Try
                'Pobieranie nazwy pliku.
                strFileName = OpenFileDialog1.FileName

                Dim fileContents As String
                fileContents = My.Computer.FileSystem.ReadAllText(strFileName)

                'Wyświetlanie zawartości pliku w polu tekstowym.
                txtFile.Text = fileContents

            Catch ex As Exception
                MessageBox.Show(ex.Message, My.Application.Info.Title, _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)
            End Try
        End If

    End Sub

    Private Sub btnSave_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnSave.Click
        'Ustawianie właściwości okna dialogowego Zapisz.
        With SaveFileDialog1
            .DefaultExt = "txt"
            .FileName = strFileName
            .Filter = "Pliki tekstowe (*.txt)|*.txt|Wszystkie pliki (*.*)|*.*"
            .FilterIndex = 1
            .OverwritePrompt = True
            .Title = "Okno dialogowe Zapisz"
        End With

        'Wyświetlanie okna dialogowego. Jeśli użytkownik kliknie przycisk Zapisz,
        'program zapisuje plik.
        If SaveFileDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            Try
                'Zapisywanie nazwy pliku.
                strFileName = SaveFileDialog1.FileName
                My.Computer.FileSystem.WriteAllText(strFileName, txtFile.Text, False)
            Catch ex As Exception
                MessageBox.Show(ex.Message, My.Application.Info.Title, _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)
            End Try
        End If

    End Sub

    Private Sub btnFont_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnFont.Click

        'Ustawianie właściwości kontrolki FontDialog.
        FontDialog1.ShowColor = True

        'Wyświetlanie kontrolki FontDialog. Jeśli użytkownik kliknie
        'przycisk OK, należy zmienić czcionkę i kolor w polu tekstowym.
        If FontDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            txtFile.Font = FontDialog1.Font
            txtFile.ForeColor = FontDialog1.Color
        End If

    End Sub

    Private Sub btnColor_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnColor.Click
        'Wyświetlanie okna dialogowego Kolor. Jeśli użytkownik kliknie 
        'przycisk OK, należy zaktualizować kolor tła formularza.
        If ColorDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            Me.BackColor = ColorDialog1.Color
        End If
    End Sub

    Private Sub DialogsPrintDocument_PrintPage(ByVal sender As Object, _
        ByVal e As System.Drawing.Printing.PrintPageEventArgs) _
        Handles DialogsPrintDocument.PrintPage
        'Deklaracje zmiennych.
        Dim intCharactersToPrint As Integer
        Dim intLinesPerPage As Integer
        Dim strPrintData As String
        Dim objStringFormat As New StringFormat
        Dim objPrintFont As New Font("Arial", 10)
        Dim objPageBoundaries As RectangleF
        Dim objPrintArea As SizeF

        'Określanie granic strony.
        objPageBoundaries = New RectangleF(e.MarginBounds.Left, _
            e.MarginBounds.Top, e.MarginBounds.Width, e.MarginBounds.Height)

        'Określanie obszaru wydruku na podstawie marginesów i użytej czcionki.
        objPrintArea = New SizeF(e.MarginBounds.Width, _
            e.MarginBounds.Height - objPrintFont.GetHeight(e.Graphics))

        'Podział między słowami w wierszu.
        objStringFormat.Trimming = StringTrimming.Word

        'Określanie liczby drukowanych znaków.
        e.Graphics.MeasureString(strPrintRecord, objPrintFont, objPrintArea, _
            objStringFormat, intCharactersToPrint, intLinesPerPage)

        'Pobieranie danych do druku ze zmiennej z tekstem.
        strPrintData = strPrintRecord.Substring(0, intCharactersToPrint)

        'Drukowanie strony.
        e.Graphics.DrawString(strPrintData, objPrintFont, Brushes.Black, _
         objPageBoundaries, objStringFormat)

        'Jeśli istnieje więcej wierszy, należy wydrukować następną stronę.
        If intCharactersToPrint < strPrintRecord.Length Then
            'Usuwanie wydrukowanego tekstu ze zmiennej.
            strPrintRecord = strPrintRecord.Remove(0, intCharactersToPrint)
            e.HasMorePages = True
        Else
            e.HasMorePages = False
        End If
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnPrint.Click
        'Tworzenie nowego obiektu typu PrintDocument.
        DialogsPrintDocument = New PrintDocument

        'Ustawianie właściwości obiektu PrintDialog.
        With PrintDialog1
            .AllowCurrentPage = False
            .AllowPrintToFile = False
            .AllowSelection = False
            .AllowSomePages = False
            .Document = DialogsPrintDocument
            .PrinterSettings.DefaultPageSettings.Margins.Top = 25
            .PrinterSettings.DefaultPageSettings.Margins.Bottom = 25
            .PrinterSettings.DefaultPageSettings.Margins.Left = 25
            .PrinterSettings.DefaultPageSettings.Margins.Right = 25
        End With

        If PrintDialog1.ShowDialog = DialogResult.OK Then
            'Zapisywanie wybranych ustawień drukarki w obiekcie PrintDocument.
            DialogsPrintDocument.PrinterSettings = _
                PrintDialog1.PrinterSettings

            'Pobieranie drukowanych danych.
            strPrintRecord = txtFile.Text

            'Wywoływanie metody Print obiektu PrintDocument.
            DialogsPrintDocument.Print()
        End If
    End Sub

    Private Sub btnBrowse_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles btnBrowse.Click
        'Ustawianie właściwości kontrolki FolderBrowserDialog.
        With FolderBrowserDialog1
            .Description = "Wybierz katalog na kopię zapasową:"
            .RootFolder = Environment.SpecialFolder.MyComputer
            .ShowNewFolderButton = False
        End With

        'Wyświetlanie okna dialogowego Przeglądanie w poszukiwaniu 
        'folderu. Jeśli użytkownik kliknie przycisk OK, należy 
        'wyświetlić wybrany katalog.
        If FolderBrowserDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            txtFile.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

End Class
